<?php
require_once '/home/crusardi/config_crusardi/database.php';
require_once __DIR__ . '/../../vendor/autoload.php';

header('Content-Type: text/plain; charset=utf-8');
@ob_end_clean();
set_time_limit(0);

function log_message($msg) {
    echo $msg . "\n";
    ob_flush();
    flush();
}

try {
    log_message("🚀 Iniciando proceso de importación...");

    $current_role = $_SESSION['user_role'] ?? 'viewer';
    if ($current_role === 'viewer') throw new Exception("🔒 No tienes permisos para importar datos.");
    
    if (!isset($_FILES['relations_file']) || $_FILES['relations_file']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception("⚠️ Archivo no recibido o error en la subida.");
    }

    $filepath = $_FILES['relations_file']['tmp_name'];
    
    $imported_count = 0;
    $skipped_count = 0;
    $total_lines = 0;
    $imported_sample = [];
    $skipped_sample = [];
    $sample_limit = 25;

    $pdo->beginTransaction();
    $stmt = $pdo->prepare("INSERT IGNORE INTO lmat_relations (lmat, parte, qty_required, fecha_creacion) VALUES (?, ?, ?, NOW())");

    // Detección automática de formato (CSV o TXT)
    $fileHandle = fopen($filepath, 'r');
    if (!$fileHandle) {
        throw new Exception("ERROR: No se pudo abrir el archivo para lectura.");
    }
    $first_line = fgets($fileHandle);
    rewind($fileHandle); // Volver al inicio del archivo

    $first_line_clean = strtolower(str_replace([' ', "\t", "\n", "\r"], '', $first_line));
    $is_csv = (
        strpos($first_line_clean, 'lmat,parte,ctd_requerida') !== false ||
        strpos($first_line_clean, 'lmat,hijas,cantidad') !== false ||
        strpos($first_line_clean, 'lmat,parte,cantidad') !== false
    );

    if ($is_csv) {
        log_message("📄 Formato CSV detectado. Procesando...");
        sleep(1);
        
        fgetcsv($fileHandle); // Omitir la cabecera
        $total_lines = 1;

        while (($data = fgetcsv($fileHandle)) !== FALSE) {
            $total_lines++;
            if (count($data) >= 3) {
                $lmat = strtoupper(trim($data[0]));
                $parte = strtoupper(trim($data[1]));
                $qty = intval(trim($data[2]));
                
                if ($lmat && $parte && $qty > 0) {
                    $stmt->execute([$lmat, $parte, $qty]);
                    if ($stmt->rowCount() > 0) {
                        $imported_count++;
                        if (count($imported_sample) < $sample_limit) {
                            $imported_sample[] = "LMAT: <strong>$lmat</strong>, Parte: <strong>$parte</strong>, Cantidad: <strong>$qty</strong>";
                        }
                    } else {
                        $skipped_count++;
                        if (count($skipped_sample) < $sample_limit) {
                           $skipped_sample[] = "LMAT: <strong>$lmat</strong>, Parte: <strong>$parte</strong>, Cantidad: <strong>$qty</strong>";
                        }
                    }
                }
            }
        }
        log_message("... Procesadas $total_lines líneas.");
        
    } else {
        log_message("📄 Formato de texto (Axapta) detectado. Procesando con tu lógica personalizada...");
        sleep(1);
        
        $current_lmat = null;
        $in_block = false;

        while (($line = fgets($fileHandle)) !== false) {
            $total_lines++;
            $line_normalized = trim(preg_replace('/\s+/', ' ', $line));

            if (stripos($line_normalized, 'Compra Inventario') !== false) {
                $in_block = true;
                $current_lmat = null;
                continue;
            }

            if ($in_block && !$current_lmat && preg_match('/^([A-Z0-9-]{8,}) \[.*?\].*?pcs.*?1[,\.]00/i', $line_normalized, $match)) {
                $current_lmat = $match[1];
                log_message("🟢 LMAT detectado: $current_lmat");
                continue;
            }

            if ($in_block && $current_lmat && preg_match('/^([A-Z0-9-]{8,}) \[.*?\].*? (\d{1,3}(?:[.,]\d{3})*)/', $line_normalized, $match)) {
                $parte = preg_replace('/\s+/', '', $match[1]);
                $qty_str = str_replace(['.', ','], ['', '.'], $match[2]);
                $qty = floatval($qty_str);
                
                if ($qty > 0) {
                    $stmt->execute([$current_lmat, $parte, $qty]);
                    if($stmt->rowCount() > 0){
                        $imported_count++;
                        if (count($imported_sample) < $sample_limit) {
                            $imported_sample[] = "LMAT: <strong>$current_lmat</strong>, Parte: <strong>$parte</strong>, Cantidad: <strong>$qty</strong>";
                        }
                    } else {
                        $skipped_count++;
                        if (count($skipped_sample) < $sample_limit) {
                           $skipped_sample[] = "LMAT: <strong>$current_lmat</strong>, Parte: <strong>$parte</strong>, Cantidad: <strong>$qty</strong>";
                        }
                    }
                }
            }
        }
    }
    
    fclose($fileHandle);
    $pdo->commit();
    
    @unlink(__DIR__ . '/../../cache/public_catalog_data.json');

    $_SESSION['import_report'] = [
        'imported_count' => $imported_count,
        'skipped_count' => $skipped_count,
        'imported' => $imported_sample, 
        'skipped' => $skipped_sample
    ];

    log_message("\n-----------------------------------------");
    log_message("✅ PROCESO COMPLETADO");
    log_message("-----------------------------------------");
    log_message("🔹 Relaciones nuevas importadas: " . $imported_count);
    log_message("🔸 Relaciones omitidas (duplicadas): " . $skipped_count);
    log_message("📄 Total de líneas procesadas: " . $total_lines);
    log_message("\n=> Haz clic en 'Cerrar y Recargar' para ver el resumen.");

} catch (Exception $e) {
    if (isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
    log_message("❌ ERROR: " . $e->getMessage());
}
?>