<?php
// /stock/index.php

// SOLUCIÓN: Activar buffer de salida para evitar problemas con headers
ob_start();

require_once '/home/crusardi/config_crusardi/database.php';
require_once __DIR__ . '/vendor/autoload.php';

// Sesión
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verificar autenticación
if (!isset($_SESSION['user_email'])) {
    // Si es una petición AJAX, devolver JSON en lugar de redireccionar
    if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && 
        strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
        
        header('Content-Type: application/json; charset=utf-8');
        header('HTTP/1.1 401 Unauthorized');
        echo json_encode([
            'success' => false, 
            'message' => 'Sesión expirada. Por favor, recargue la página.',
            'redirect' => 'auth/login.php'
        ]);
        exit;
    }
    
    // Si no es AJAX, redireccionar normalmente
    header('Location: auth/login.php');
    exit;
}

// Página actual
$page = $_GET['page'] ?? 'stock_calculado';
$allowed = [
    'stock_calculado',
    'importar_stock',
    'importar_combinaciones',
    'importar_productos',
    'cargar_imagenes',
    'descuentos',
    'excepciones',
    'gestionar_excepciones_kits',
    'productos_imperfectos',
    'upload_foto_imperfectos',
    'usuarios',
    'gestionar_categorias'
];
if (!in_array($page, $allowed, true)) {
    $page = 'stock_calculado';
}

// FUNCIONES DE SINCRONIZACIÓN DE CATEGORÍAS
function mapear_categoria_db($pdo, $grupo_articulo) {
    $grupo_upper = strtoupper(trim($grupo_articulo));
    
    // Buscar en la tabla de mapeo actualizada
    $stmt = $pdo->prepare("
        SELECT 
            c1.nombre as cat1, 
            c2.nombre as cat2
        FROM categoria_mapping cm
        LEFT JOIN categorias_nivel1 c1 ON cm.categoria1_id = c1.id
        LEFT JOIN categorias_nivel2 c2 ON cm.categoria2_id = c2.id
        WHERE cm.grupo_articulo = ? AND cm.activo = 1
    ");
    $stmt->execute([$grupo_upper]);
    $result = $stmt->fetch();
    
    if ($result) {
        return ['cat1' => $result['cat1'] ?: 'Otros', 'cat2' => $result['cat2'] ?: 'General'];
    }
    
    // Si no hay coincidencia exacta, buscar coincidencia parcial
    $stmt = $pdo->prepare("
        SELECT 
            c1.nombre as cat1, 
            c2.nombre as cat2
        FROM categoria_mapping cm
        LEFT JOIN categorias_nivel1 c1 ON cm.categoria1_id = c1.id
        LEFT JOIN categorias_nivel2 c2 ON cm.categoria2_id = c2.id
        WHERE ? LIKE CONCAT('%', cm.grupo_articulo, '%') AND cm.activo = 1 
        ORDER BY LENGTH(cm.grupo_articulo) DESC LIMIT 1
    ");
    $stmt->execute([$grupo_upper]);
    $result = $stmt->fetch();
    
    if ($result) {
        return ['cat1' => $result['cat1'] ?: 'Otros', 'cat2' => $result['cat2'] ?: 'General'];
    }
    
    // Default
    return ['cat1' => 'Otros', 'cat2' => 'General'];
}

// Gestión de acciones de categorías
if ($page === 'gestionar_categorias' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    // Tu código existente de gestión de categorías aquí
    // No lo modifico porque no tengo el código completo
}

// Gestión de acciones generales
if (isset($_REQUEST['action'])) {
    $action = basename($_REQUEST['action']);
    $action_file = __DIR__ . '/pages/actions/' . $action . '.php';
    if (file_exists($action_file)) {
        include $action_file;
        exit;
    }
}

// Inicializar variable de error de base de datos
$db_error = null;

// Incluir página solicitada
$page_path = __DIR__ . '/pages/' . $page . '.php';

// AHORA SÍ EMPIEZA EL HTML
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Stock BoConcept - Crusardi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        .sidebar-link {
            transition: all 0.2s ease;
        }
        .sidebar-link:hover {
            transform: translateX(4px);
        }
        @keyframes slideIn {
            from { transform: translateX(-100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
        .animate-slide-in {
            animation: slideIn 0.3s ease-out;
        }
    </style>
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
</head>
<body class="bg-gray-50">

    <div x-data="{ sidebarOpen: false }" class="relative min-h-screen flex">

        <!-- Overlay móvil -->
        <div x-show="sidebarOpen" 
             x-transition:enter="transition-opacity ease-linear duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition-opacity ease-linear duration-300"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             @click="sidebarOpen = false"
             class="fixed inset-0 bg-black bg-opacity-50 z-30 lg:hidden"></div>

        <!-- Sidebar -->
        <aside 
            class="fixed inset-y-0 left-0 bg-gradient-to-b from-gray-900 to-gray-800 text-white w-72 py-6 px-5 transform transition-transform duration-300 ease-in-out z-40 lg:relative lg:translate-x-0 shadow-xl"
            :class="{'translate-x-0 animate-slide-in': sidebarOpen, '-translate-x-full': !sidebarOpen}">
            
            <!-- Logo y título -->
            <div class="flex flex-col items-center mb-8 pb-6 border-b border-gray-700">
                <div class="bg-white rounded-xl p-3 mb-3 shadow-lg">
                    <img src="assets/logo.png" alt="BoConcept" class="h-16 w-auto">
                </div>
                <h1 class="text-2xl font-bold">Crusardi</h1>
                <span class="text-sm text-gray-400 mt-1">Sistema de Gestión de Stock</span>
            </div>

            <!-- Navegación -->
            <nav class="space-y-2">
                <?php if ($_SESSION['user_role'] === 'viewer'): ?>
                    <a href="index.php?page=stock_calculado" 
                       class="sidebar-link flex items-center px-4 py-3 rounded-lg <?php echo $page === 'stock_calculado' ? 'bg-indigo-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700 hover:text-white'; ?>">
                        <i class="fas fa-chart-line w-5"></i>
                        <span class="ml-3 font-medium">Visor de Stock</span>
                    </a>
                <?php else: ?>
                    <!-- Vista principal -->
                    <a href="index.php?page=stock_calculado" 
                       class="sidebar-link flex items-center px-4 py-3 rounded-lg <?php echo $page === 'stock_calculado' ? 'bg-indigo-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700 hover:text-white'; ?>">
                        <i class="fas fa-chart-line w-5"></i>
                        <span class="ml-3 font-medium">Visor de Stock</span>
                    </a>
                    
                    <!-- Sección de Importación -->
                    <div x-data="{ open: <?php echo in_array($page, ['importar_stock', 'importar_combinaciones', 'importar_productos']) ? 'true' : 'false'; ?> }" class="mt-6">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg text-gray-300 hover:bg-gray-700 hover:text-white transition-all duration-200">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-file-import w-5"></i>
                                <span class="font-medium">Importación</span>
                            </div>
                            <i class="fas fa-chevron-down transition-transform duration-200 text-sm" :class="{'rotate-180': open}"></i>
                        </button>
                        <div x-show="open" 
                             x-transition:enter="transition ease-out duration-200"
                             x-transition:enter-start="opacity-0 transform -translate-y-2"
                             x-transition:enter-end="opacity-100 transform translate-y-0"
                             class="mt-2 ml-8 space-y-1">
                            <a href="index.php?page=importar_stock" 
                               class="sidebar-link block px-4 py-2 rounded-md text-sm <?php echo $page === 'importar_stock' ? 'bg-indigo-600 text-white' : 'text-gray-400 hover:bg-gray-700 hover:text-white'; ?>">
                                <i class="fas fa-boxes w-4 mr-2"></i>Stock Físico
                            </a>
                            <a href="index.php?page=importar_combinaciones" 
                               class="sidebar-link block px-4 py-2 rounded-md text-sm <?php echo $page === 'importar_combinaciones' ? 'bg-indigo-600 text-white' : 'text-gray-400 hover:bg-gray-700 hover:text-white'; ?>">
                                <i class="fas fa-box-open w-4 mr-2"></i>KITS / Recetas
                            </a>
                            <a href="index.php?page=importar_productos" 
                               class="sidebar-link block px-4 py-2 rounded-md text-sm <?php echo $page === 'importar_productos' ? 'bg-indigo-600 text-white' : 'text-gray-400 hover:bg-gray-700 hover:text-white'; ?>">
                                <i class="fas fa-shopping-cart w-4 mr-2"></i>Productos
                            </a>
                        </div>
                    </div>
                    
                    <!-- Sección de Configuración -->
                    <div x-data="{ open: <?php echo in_array($page, ['gestionar_categorias', 'cargar_imagenes', 'descuentos', 'excepciones', 'gestionar_excepciones_kits']) ? 'true' : 'false'; ?> }" class="mt-4">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg text-gray-300 hover:bg-gray-700 hover:text-white transition-all duration-200">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-cog w-5"></i>
                                <span class="font-medium">Configuración</span>
                            </div>
                            <i class="fas fa-chevron-down transition-transform duration-200 text-sm" :class="{'rotate-180': open}"></i>
                        </button>
                        <div x-show="open" 
                             x-transition:enter="transition ease-out duration-200"
                             x-transition:enter-start="opacity-0 transform -translate-y-2"
                             x-transition:enter-end="opacity-100 transform translate-y-0"
                             class="mt-2 ml-8 space-y-1">
                            <a href="index.php?page=gestionar_categorias" 
                               class="sidebar-link block px-4 py-2 rounded-md text-sm <?php echo $page === 'gestionar_categorias' ? 'bg-indigo-600 text-white' : 'text-gray-400 hover:bg-gray-700 hover:text-white'; ?>">
                                <i class="fas fa-tags w-4 mr-2"></i>Categorías
                            </a>
                            <a href="index.php?page=cargar_imagenes" 
                               class="sidebar-link block px-4 py-2 rounded-md text-sm <?php echo $page === 'cargar_imagenes' ? 'bg-indigo-600 text-white' : 'text-gray-400 hover:bg-gray-700 hover:text-white'; ?>">
                                <i class="fas fa-image w-4 mr-2"></i>Cargar Imágenes
                            </a>
                            <a href="index.php?page=descuentos" 
                               class="sidebar-link block px-4 py-2 rounded-md text-sm <?php echo $page === 'descuentos' ? 'bg-indigo-600 text-white' : 'text-gray-400 hover:bg-gray-700 hover:text-white'; ?>">
                                <i class="fas fa-percent w-4 mr-2"></i>Descuentos
                            </a>
                            <a href="index.php?page=gestionar_excepciones_kits" 
                               class="sidebar-link block px-4 py-2 rounded-md text-sm <?php echo $page === 'gestionar_excepciones_kits' ? 'bg-indigo-600 text-white' : 'text-gray-400 hover:bg-gray-700 hover:text-white'; ?>">
                                <i class="fas fa-exclamation-triangle w-4 mr-2"></i>Excepciones KITS
                            </a>
                        </div>
                    </div>
                    
                    <!-- Sección de Productos Especiales -->
                    <div x-data="{ open: <?php echo in_array($page, ['productos_imperfectos']) ? 'true' : 'false'; ?> }" class="mt-4">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg text-gray-300 hover:bg-gray-700 hover:text-white transition-all duration-200">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-box w-5"></i>
                                <span class="font-medium">Productos Especiales</span>
                            </div>
                            <i class="fas fa-chevron-down transition-transform duration-200 text-sm" :class="{'rotate-180': open}"></i>
                        </button>
                        <div x-show="open" 
                             x-transition:enter="transition ease-out duration-200"
                             x-transition:enter-start="opacity-0 transform -translate-y-2"
                             x-transition:enter-end="opacity-100 transform translate-y-0"
                             class="mt-2 ml-8 space-y-1">
                            <a href="index.php?page=productos_imperfectos" 
                               class="sidebar-link block px-4 py-2 rounded-md text-sm <?php echo $page === 'productos_imperfectos' ? 'bg-indigo-600 text-white' : 'text-gray-400 hover:bg-gray-700 hover:text-white'; ?>">
                                <i class="fas fa-tools w-4 mr-2"></i>Productos Imperfectos
                            </a>
                        </div>
                    </div>
                    
                    <?php if ($_SESSION['user_role'] === 'admin'): ?>
                    <!-- Sección de Administración (solo admin) -->
                    <div x-data="{ open: <?php echo in_array($page, ['usuarios']) ? 'true' : 'false'; ?> }" class="mt-4">
                        <button @click="open = !open" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg text-gray-300 hover:bg-gray-700 hover:text-white transition-all duration-200">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-shield-alt w-5"></i>
                                <span class="font-medium">Administración</span>
                            </div>
                            <i class="fas fa-chevron-down transition-transform duration-200 text-sm" :class="{'rotate-180': open}"></i>
                        </button>
                        <div x-show="open" 
                             x-transition:enter="transition ease-out duration-200"
                             x-transition:enter-start="opacity-0 transform -translate-y-2"
                             x-transition:enter-end="opacity-100 transform translate-y-0"
                             class="mt-2 ml-8 space-y-1">
                            <a href="index.php?page=usuarios" 
                               class="sidebar-link block px-4 py-2 rounded-md text-sm <?php echo $page === 'usuarios' ? 'bg-indigo-600 text-white' : 'text-gray-400 hover:bg-gray-700 hover:text-white'; ?>">
                                <i class="fas fa-users w-4 mr-2"></i>Usuarios
                            </a>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>
            </nav>

            <!-- Usuario -->
            <div class="absolute bottom-0 left-0 right-0 p-5 border-t border-gray-700">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="bg-indigo-600 rounded-full p-2 mr-3">
                            <i class="fas fa-user text-white text-sm"></i>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-white"><?php echo htmlspecialchars($_SESSION['user_name']); ?></p>
                            <p class="text-xs text-gray-400"><?php echo ucfirst($_SESSION['user_role']); ?></p>
                        </div>
                    </div>
                    <a href="auth/logout.php" class="text-red-400 hover:text-red-300 transition-colors">
                        <i class="fas fa-sign-out-alt"></i>
                    </a>
                </div>
            </div>
        </aside>

        <!-- Contenido principal -->
        <div class="flex-1 flex flex-col">
            <!-- Header móvil -->
            <header class="lg:hidden bg-white shadow-sm p-4 flex justify-between items-center">
                <div class="flex items-center">
                    <img src="assets/logo.png" alt="BoConcept" class="h-10 w-auto mr-3">
                    <span class="text-lg font-semibold text-gray-800">Crusardi Stock</span>
                </div>
                <button @click="sidebarOpen = !sidebarOpen" class="text-gray-600 hover:text-gray-900">
                    <i class="fas fa-bars text-xl"></i>
                </button>
            </header>

            <!-- Contenido de la página -->
            <main class="flex-1 p-6 overflow-y-auto">
                <?php if ($db_error): ?>
                    <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4">
                        <p class="font-bold">Error de conexión</p>
                        <p><?php echo htmlspecialchars($db_error); ?></p>
                    </div>
                <?php elseif (file_exists($page_path)): ?>
                    <?php include $page_path; ?>
                <?php else: ?>
                    <div class="bg-yellow-100 border-l-4 border-yellow-500 text-yellow-700 p-4">
                        <p class="font-bold">Página no encontrada</p>
                        <p>La página solicitada no existe.</p>
                    </div>
                <?php endif; ?>
            </main>
        </div>
    </div>

</body>
</html>
<?php
// SOLUCIÓN: Enviar el buffer al final
ob_end_flush();
?>