<?php
// auth/login.php

// 1) Iniciar sesión y forzar UTF‑8
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
header('Content-Type: text/html; charset=UTF-8');

// 2) Cargar dependencias
require_once '/home/crusardi/config_crusardi/database.php';
require_once __DIR__ . '/../vendor/autoload.php';

// 3) Configurar Google Client
$client = new Google_Client();
$client->setClientId(GOOGLE_CLIENT_ID);
$client->setClientSecret(GOOGLE_CLIENT_SECRET);
$client->setRedirectUri('https://stock.crusardi.net/auth/callback.php');
$client->addScope('email');
$client->addScope('profile');

// 4) Si ya está autenticado, redirige al index
if (isset($_SESSION['user_email'])) {
    header('Location: ../index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Iniciar Sesión</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link 
    rel="stylesheet" 
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
  >
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen p-4">
  <div class="w-full max-w-sm bg-white p-4 sm:p-8 rounded-xl shadow-lg text-center">
    
    <!-- Logo BoConcept -->
    <img
        src="/assets/logo.png"
        alt="BoConcept Logo"
        class="mx-auto mb-0 h-30 sm:h-34 md:h-38 w-auto"
    />
    <h1 class="text-1xl sm:text-1xl md:text-2xl font-bold text-gray-800 mb-2">
        Transformamos espacios en personas felices 💖
    </h1>
    <p class="text-sm sm:text-base text-gray-500 mb-6">
      Por favor, inicia sesión para continuar.
    </p>

    <?php if (!empty($_GET['error'])): ?>
      <p class="text-xs sm:text-sm text-red-500 mb-4">
        Acceso denegado. Contacta al administrador.
      </p>
    <?php endif; ?>

    <a 
      href="<?= htmlspecialchars($client->createAuthUrl()) ?>" 
      class="w-full inline-flex justify-center items-center gap-2 sm:gap-3 bg-blue-600 text-white font-semibold py-2 sm:py-3 px-4 sm:px-6 rounded-lg hover:bg-blue-700 transition-colors text-sm sm:text-base"
    >
      <i class="fab fa-google text-lg sm:text-xl"></i>
      <span>Iniciar Sesión con Google</span>
    </a>
  </div>
</body>
</html>
