<?php
// auth/callback.php

// Iniciar sesión si aún no está iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// --- CARGA DE DEPENDENCIAS ---
require_once '/home/crusardi/config_crusardi/database.php';  // Conexión a la base de datos
require_once __DIR__ . '/../vendor/autoload.php';            // Autoload de Composer

// --- CONFIGURACIÓN DEL CLIENTE DE Google ---
$client = new Google_Client();
$client->setClientId(GOOGLE_CLIENT_ID);
$client->setClientSecret(GOOGLE_CLIENT_SECRET);
// Asegúrate de que esta URL esté autorizada en la consola de Google Cloud
$client->setRedirectUri('https://stock.crusardi.net/auth/callback.php');
$client->addScope("email");
$client->addScope("profile");

// --- DOMINIOS PERMITIDOS ---
$allowed_domains = [
    'crusardi.net',
    'boconcept.com.co',
    'gmail.com'
    // añade aquí tantos dominios como necesites
];

// --- PROCESO DE AUTENTICACIÓN ---
if (isset($_GET['code'])) {
    // 1. Intercambiar el código por un token de acceso
    $token = $client->fetchAccessTokenWithAuthCode($_GET['code']);
    if (isset($token['error'])) {
        die('Error al obtener el token de acceso: ' . $token['error_description']);
    }

    // 2. Establecer token y obtener información del usuario
    $client->setAccessToken($token['access_token']);
    $google_oauth = new Google_Service_Oauth2($client);
    $google_account_info = $google_oauth->userinfo->get();
    
    $email  = $google_account_info->email;
    $name   = $google_account_info->name;
    $domain = strtolower(substr(strrchr($email, "@"), 1)); // extrae dominio y lo pasa a minúsculas

    // 3. Verificar si el dominio está en la lista de permitidos
    if (in_array($domain, $allowed_domains, true)) {
        // 3.a. Buscar usuario en la base de datos
        $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch();

        if ($user) {
            // Usuario existente: cargar datos en sesión
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_email'] = $user['email'];
            $_SESSION['user_name']  = $user['name'];
            $_SESSION['user_role']  = $user['role'];
        } else {
            // Nuevo usuario: insertar con rol 'viewer' por defecto
            $stmt = $pdo->prepare("INSERT INTO users (email, name, role) VALUES (?, ?, 'viewer')");
            $stmt->execute([$email, $name]);

            $user_id = $pdo->lastInsertId();
            
            $_SESSION['user_id'] = $user_id;
            $_SESSION['user_email'] = $email;
            $_SESSION['user_name']  = $name;
            $_SESSION['user_role']  = 'viewer';
        }
    } else {
        // Dominio no permitido
        $lista = implode(', ', $allowed_domains);
        die('Acceso denegado. Solo se permiten usuarios de los dominios: ' . $lista . '.');
    }

    // 4. Redirigir al usuario ya autenticado
    header('Location: https://stock.crusardi.net/index.php');
    exit;
} else {
    // Si no hay código, volver al formulario de login
    header('Location: login.php');
    exit;
}
